/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.regexp;

import gnu.trove.iterator.hash.TObjectHashIterator;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import org.simantics.scl.compiler.parser.regexp.Namer;
import org.simantics.scl.compiler.parser.regexp.ROp;
import org.simantics.scl.compiler.parser.regexp.RSeq;
import org.simantics.scl.compiler.parser.regexp.Regexp;
import org.simantics.scl.compiler.parser.regexp.automata.NFA;

public class ROr
extends Regexp {
    public final Regexp[] exps;

    ROr(Regexp[] exps) {
        this.exps = exps;
    }

    @Override
    protected void buildAutomaton(NFA aut, int inState, int outState) {
        Regexp[] regexpArray = this.exps;
        int n = this.exps.length;
        int n2 = 0;
        while (n2 < n) {
            Regexp exp = regexpArray[n2];
            exp.buildAutomaton(aut, inState, outState);
            ++n2;
        }
    }

    @Override
    protected void toString(StringBuilder b, int prec) {
        if (prec >= 1) {
            b.append('(');
        }
        boolean first = true;
        Regexp[] regexpArray = this.exps;
        int n = this.exps.length;
        int n2 = 0;
        while (n2 < n) {
            Regexp exp = regexpArray[n2];
            if (first) {
                first = false;
            } else {
                b.append(" | ");
            }
            exp.toString(b, 1);
            ++n2;
        }
        if (prec >= 1) {
            b.append(')');
        }
    }

    @Override
    public void toString(StringBuilder b, Namer grammar, int prec) {
        if (prec >= 1) {
            b.append('(');
        }
        boolean first = true;
        Regexp[] regexpArray = this.exps;
        int n = this.exps.length;
        int n2 = 0;
        while (n2 < n) {
            Regexp exp = regexpArray[n2];
            if (first) {
                first = false;
            } else {
                b.append(" | ");
            }
            exp.toString(b, grammar, 1);
            ++n2;
        }
        if (prec >= 1) {
            b.append(')');
        }
    }

    @Override
    protected int getTypeId() {
        return 2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ROr other = (ROr)obj;
        return Arrays.equals(this.exps, other.exps);
    }

    public int hashCode() {
        int r = 34235;
        Regexp[] regexpArray = this.exps;
        int n = this.exps.length;
        int n2 = 0;
        while (n2 < n) {
            Regexp exp = regexpArray[n2];
            r *= 31;
            r += exp.hashCode();
            ++n2;
        }
        return r;
    }

    @Override
    public boolean isNullable() {
        Regexp[] regexpArray = this.exps;
        int n = this.exps.length;
        int n2 = 0;
        while (n2 < n) {
            Regexp exp = regexpArray[n2];
            if (exp.isNullable()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Regexp simplify(THashSet<Regexp> set) {
        Regexp exp;
        boolean qm;
        block9: {
            block8: {
                THashSet set2;
                Regexp temp;
                Regexp common;
                TObjectHashIterator it;
                block7: {
                    qm = set.remove((Object)ONE);
                    if (set.size() <= 1) break block8;
                    it = set.iterator();
                    common = ROr.front((Regexp)it.next());
                    while (it.hasNext()) {
                        temp = ROr.front((Regexp)it.next());
                        if (temp.equals(common)) {
                            continue;
                        }
                        break block7;
                    }
                    set2 = new THashSet();
                    for (Regexp e : set) {
                        set2.add((Object)ROr.removeFront(e));
                    }
                    exp = ROr.seq(common, this.simplify((THashSet<Regexp>)set2));
                    break block9;
                }
                it = set.iterator();
                common = ROr.back((Regexp)it.next());
                while (it.hasNext()) {
                    temp = ROr.back((Regexp)it.next());
                    if (temp.equals(common)) {
                        continue;
                    }
                    break block8;
                }
                set2 = new THashSet();
                for (Regexp e : set) {
                    set2.add((Object)ROr.removeBack(e));
                }
                exp = ROr.seq(this.simplify((THashSet<Regexp>)set2), common);
                break block9;
            }
            exp = ROr.or(set);
        }
        if (qm && !exp.isNullable()) {
            exp = new ROp(exp, '?');
        }
        return exp;
    }

    @Override
    public Regexp simplify() {
        if (this.exps.length == 0) {
            return this;
        }
        THashSet set = new THashSet();
        Regexp[] regexpArray = this.exps;
        int n = this.exps.length;
        int n2 = 0;
        while (n2 < n) {
            Regexp exp = regexpArray[n2];
            exp = exp.simplify();
            ROr.or((THashSet<Regexp>)set, exp);
            ++n2;
        }
        return this.simplify((THashSet<Regexp>)set);
    }

    private static Regexp front(Regexp exp) {
        if (exp instanceof RSeq) {
            Regexp[] exps = ((RSeq)exp).exps;
            if (exps.length == 0) {
                return null;
            }
            return exps[0];
        }
        return exp;
    }

    private static Regexp removeFront(Regexp exp) {
        if (exp instanceof RSeq) {
            Regexp[] exps = ((RSeq)exp).exps;
            return ROr.seq_(Arrays.asList(exps).subList(1, exps.length));
        }
        return ONE;
    }

    private static Regexp back(Regexp exp) {
        if (exp instanceof RSeq) {
            Regexp[] exps = ((RSeq)exp).exps;
            if (exps.length == 0) {
                return null;
            }
            return exps[exps.length - 1];
        }
        return exp;
    }

    private static Regexp removeBack(Regexp exp) {
        if (exp instanceof RSeq) {
            Regexp[] exps = ((RSeq)exp).exps;
            return ROr.seq_(Arrays.asList(exps).subList(0, exps.length - 1));
        }
        return ONE;
    }
}

