/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query.compilation;

import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryConstraint;

public class RelationConstraint
extends QueryConstraint {
    QAtom atom;
    int[] optionalVariableByParameter;
    Variable[] parameters;
    long requiredVariablesMask;

    public RelationConstraint(int[] variables, Variable[] parameters, QAtom atom, int[] optionalVariableByParameter, long requiredVariablesMask) {
        super(variables);
        this.atom = atom;
        this.parameters = parameters;
        this.optionalVariableByParameter = optionalVariableByParameter;
        this.requiredVariablesMask = requiredVariablesMask;
    }

    @Override
    public boolean canBeSolvedFrom(long boundVariables) {
        return this.getSolutionBranching(boundVariables) != Double.POSITIVE_INFINITY;
    }

    @Override
    public double getSolutionBranching(long boundVariables) {
        if ((boundVariables & this.requiredVariablesMask) != this.requiredVariablesMask) {
            return Double.POSITIVE_INFINITY;
        }
        return this.atom.relation.getSelectivity(this.getLocalBoundVariables(boundVariables));
    }

    @Override
    public double getSolutionCost(long boundVariables) {
        return 1.0;
    }

    @Override
    public void generate(QueryCompilationContext context) {
        this.atom.relation.generate(this.atom.location, context, this.atom.typeParameters, this.parameters, this.getLocalBoundVariables(this.finalBoundVariables));
        int i = this.atom.parameters.length - 1;
        while (i >= 0) {
            if (this.optionalVariableByParameter[i] < 0 && !(this.atom.parameters[i] instanceof EVariable)) {
                context.let(this.parameters[i], this.atom.parameters[i]);
            }
            --i;
        }
    }

    private int getLocalBoundVariables(long boundVariables) {
        int localBoundVariables = 0;
        int i = 0;
        while (i < this.optionalVariableByParameter.length) {
            int v = this.optionalVariableByParameter[i];
            if (v < 0 || (boundVariables >> v & 1L) != 0L) {
                localBoundVariables |= 1 << i;
            }
            ++i;
        }
        return localBoundVariables;
    }

    public String toString() {
        return this.atom.toString();
    }
}

