package org.simantics.scl.compiler.types.exceptions;

public class Problem {
    int start;
    int end;
    String description;

    public Problem(int start, int end, String description) {
        this.start = start;
        this.end = end;
        this.description = description;
    }
    
    public int getStart() {
        return start;
    }
    
    public int getEnd() {
        return end;
    }
    
    public String getDescription() {
        return description;
    }    
    
    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        toString(b);
        return b.toString();
    }

    void toString(StringBuilder b) {
        b.append(start);
        b.append("-");
        b.append(end);
        b.append(": ");
        b.append(description);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result
                + ((description == null) ? 0 : description.hashCode());
        result = prime * result + end;
        result = prime * result + start;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Problem other = (Problem) obj;
        if (description == null) {
            if (other.description != null)
                return false;
        } else if (!description.equals(other.description))
            return false;
        if (end != other.end)
            return false;
        if (start != other.start)
            return false;
        return true;
    }
}
