package org.simantics.scl.compiler.internal.types.ast;

import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.SCLTypeParseException;



public class TTupleAst extends TypeAst {
    public final TypeAst[] components;
    
    public TTupleAst(TypeAst ... components) {
        this.components = components;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append('(');
        for(int i=0;i<components.length;++i) {
            if(i > 0)
                b.append(", ");
            components[i].toString(b);
        }
        b.append(')');
    }

    @Override
    public Type toType(TypeElaborationContext context) throws SCLTypeParseException {
        return Types.tuple(toTypes(context, components));
    }

    @Override
    public int getPrecedence() {
        return 0;
    }
}
