package org.simantics.scl.compiler.internal.parsing.translation;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.scl.compiler.elaboration.errors.NotPatternException;
import org.simantics.scl.compiler.internal.parsing.declarations.DAnnotationAst;
import org.simantics.scl.compiler.internal.parsing.declarations.DRelationAst;

import gnu.trove.map.hash.THashMap;

public class RelationRepository {
    THashMap<String, ArrayList<DRelationAst>> relations = 
            new THashMap<String, ArrayList<DRelationAst>>();
    THashMap<String, ArrayList<DAnnotationAst>> annotations = 
            new THashMap<String, ArrayList<DAnnotationAst>>();
            
    public String add(DRelationAst relation) throws NotPatternException {
        String name = relation.lhs.getPatternHead().name;
        ArrayList<DRelationAst> vs = relations.get(name);
        if(vs == null) {
            vs = new ArrayList<DRelationAst>(2);
            relations.put(name, vs);
        }
        vs.add(relation);
        return name;
    }
    
    public void addDefinitions(String name, ArrayList<DRelationAst> relationList) {
        ArrayList<DRelationAst> vs = relations.get(name);
        if(vs == null) {
            vs = new ArrayList<DRelationAst>(relationList.size());
            relations.put(name, vs);
        }
        vs.addAll(relationList);
    }
    
    public void addAnnotation(String name, DAnnotationAst annotation) {
        ArrayList<DAnnotationAst> as = annotations.get(name);
        if(as == null) {
            as = new ArrayList<DAnnotationAst>(2);
            annotations.put(name, as);
        }
        as.add(annotation);
    }
    
    public void addAnnotations(String name, ArrayList<DAnnotationAst> annotationList) {
        ArrayList<DAnnotationAst> as = annotations.get(name);
        if(as == null) {
            as = new ArrayList<DAnnotationAst>(annotationList.size());
            annotations.put(name, as);
        }
        as.addAll(annotationList);
    }
    
    public Collection<String> getRelationNames() {
        return relations.keySet();
    }

    public ArrayList<DRelationAst> getDefinition(String name) {
        return relations.get(name);
    }

    public ArrayList<DAnnotationAst> getAnnotations(String name) {
        return annotations.get(name);
    }

    public void addFrom(RelationRepository repo, String oldName, String newName) {
        addDefinitions(newName, repo.getDefinition(oldName));
        
        ArrayList<DAnnotationAst> as = repo.getAnnotations(oldName);
        if(as != null)
            addAnnotations(newName, as);
    }
}
