package org.simantics.scl.compiler.environment.filter;

public class NamespaceFilterUnion implements NamespaceFilter {
    private final NamespaceFilter a;
    private final NamespaceFilter b;
    
    public NamespaceFilterUnion(NamespaceFilter a, NamespaceFilter b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public boolean isValueIncluded(String name) {
        return a.isValueIncluded(name) || b.isValueIncluded(name);
    }

    @Override
    public boolean isSubsetOf(NamespaceFilter filter) {
        return false;
    }
}
