package org.simantics.scl.compiler.elaboration.expressions.block;

import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.parsing.Token;
import org.simantics.scl.compiler.internal.parsing.declarations.DAnnotationAst;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;

public class ConstraintStatement extends Statement {

    public Token name;
    public TypeAst[] parameterTypes;
    public String[] fieldNames;
    public DAnnotationAst[] annotations;
    
    public ConstraintStatement(Token name, TypeAst[] parameterTypes, String[] fieldNames, DAnnotationAst[] annotations) {
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.fieldNames = fieldNames;
        this.annotations = annotations;
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            for(TypeAst parameterType : parameterTypes)
                if(parameterType.location == Locations.NO_LOCATION)
                    parameterType.location = location;
        }
    }

    @Override
    public Expression toExpression(EnvironmentalContext context, BlockType blockType, Expression in) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resolvePattern(TranslationContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean mayBeRecursive() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(StatementVisitor visitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StatementGroup getStatementGroup() {
        return StatementGroup.CHR;
    }
}
