package org.simantics.scl.compiler.elaboration.expressions.accessor;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.internal.parsing.Symbol;

public abstract class FieldAccessor extends Symbol {
    public char accessSeparator;
    
    public FieldAccessor(char accessSeparator) {
        this.accessSeparator = accessSeparator;
    }

    public void simplify(SimplificationContext context) {
    }

    public void resolve(TranslationContext context) {
    }

    public void checkType(TypingContext context) {
    }

    public abstract Expression asExpression();

    public boolean isVariableId() {
        return false;
    }

    public abstract void setLocationDeep(long loc);

    public abstract void accept(FieldAccessorVisitor visitor);
}
