package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.equation.Equation;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class EEquations extends SimplifiableExpression {

    public Equation[] equations;
    public Type effect = Types.NO_EFFECTS;
    
    public EEquations(Equation[] equations) {
        this.equations = equations;
    }
    
    public EEquations(long location, Equation[] equations) {
        this(equations);
        this.location = location;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        for(Equation equation : equations)
            equation.resolve(context);       
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            for(Equation equation : equations)
                equation.setLocationDeep(loc);
        }
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    protected void updateType() throws MatchException {
        setType(Types.UNIT);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
    
    @Override
    public Expression inferType(TypingContext context) {
        context.declareEffect(this.location, effect);
        for(Equation equation : equations)
            equation.checkType(context);
        return this;
    }
    
    @Override
    public Expression checkIgnoredType(TypingContext context) {
        return inferType(context);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        context.getErrorLog().log(location, "Equations should be transformed into other expressions before simplification phase.");
        return Expressions.tuple();
    }
    
    @Override
    public Expression replace(ReplaceContext context) {
        Equation[] newEquations = new Equation[equations.length];
        for(int i=0;i<equations.length;++i)
            newEquations[i] = equations[i].replace(context);
        return new EEquations(location, newEquations);
    }

}
