package org.simantics.scl.compiler.common.names;

import org.simantics.scl.compiler.internal.types.HashConsing;

public final class Name {
    public static final Name[] EMPTY_ARRAY = new Name[0];
    
    public final String module;
    public final String name;
    
    private Name(String module, String name) {
        this.module = module;
        this.name = name;
    }
    
    private static final HashConsing<Name> nameCache = 
            new HashConsing<Name>() {
        protected boolean equals(Name a, Name b) {
            return a.name.equals(b.name) && a.module.equals(b.module);
        }

        protected int hashCode(Name obj) {
            return obj.module.hashCode()*31 + obj.name.hashCode();
        }
    };
    
    public String toString() {
        return module + "/" + name;
    }
    
    public static Name create(String module, String name) {
        return nameCache.canonical(new Name(module, name));
    }
}
