/*******************************************************************************
 * Copyright (c) 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Color;
import java.awt.geom.Point2D;

/**
 * @author Tuukka Lehtonen
 * @since 1.58.0
 */
public class TwoWayBoxSelectionStrategy implements BoxSelectionStrategy {

	private final Color containColor;
	private final Color intersectColor;

	public TwoWayBoxSelectionStrategy(Color containColor, Color intersectColor) {
		this.containColor = containColor;
		this.intersectColor = intersectColor;
	}

	private static boolean expandsToRight(Point2D start, Point2D end) {
		return start.getX() < end.getX();
	}

	@Override
	public Color selectionBoxColor(Point2D start, Point2D end) {
		if (expandsToRight(start, end)) {
			return containColor;
		} else {
			return intersectColor;
		}
	}

	@Override
	public SelectionPolicy chooseSelectionPolicy(Point2D start, Point2D end) {
		return expandsToRight(start, end)
				? SelectionPolicy.SELECT_CONTAINED
				: SelectionPolicy.SELECT_INTERSECTING;
	}

}