package org.simantics.scenegraph.g2d.nodes;

import java.util.Arrays;

public class PathNodeStyle {

    private float[] color;
    private float[] fillColor;
    private float strokeWidth;
    
    public PathNodeStyle(float[] color, float[] fillColor, float strokeWidth) {
        this.color = color;
        this.fillColor = fillColor;
        this.strokeWidth = strokeWidth;
    }
    
    float[] getColor() {
        return color;
    }

    float[] getFillColor() {
        return fillColor;
    }

    float getStrokeWidth() {
        return strokeWidth;
    }
    
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(color);
        result = prime * result + Arrays.hashCode(fillColor);
        result = prime * result + Float.floatToIntBits(strokeWidth);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        PathNodeStyle other = (PathNodeStyle) obj;
        if (!Arrays.equals(color, other.color))
            return false;
        if (!Arrays.equals(fillColor, other.fillColor))
            return false;
        if (Float.floatToIntBits(strokeWidth) != Float.floatToIntBits(other.strokeWidth))
            return false;
        return true;
    }
}
