/*******************************************************************************
 * Copyright (c) 2020 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

import org.simantics.diagram.connection.rendering.ConnectionCrossings;
import org.simantics.diagram.connection.rendering.ConnectionRenderingHints;
import org.simantics.scenegraph.g2d.G2DNode;

public class ConnectionCrossingsNode extends G2DNode {

    private static final long serialVersionUID = -696142275610396889L;

    private ConnectionCrossings crossings;
    
    @Override
    public void render(Graphics2D g) {
        crossings.reset();
        if (crossings.getWidth() > 0 && crossings.getType() != ConnectionCrossings.Type.NONE)  {
            g.setRenderingHint(ConnectionRenderingHints.KEY_PATH_MODIFIER, crossings);
        } else {
            g.setRenderingHint(ConnectionRenderingHints.KEY_PATH_MODIFIER, null);
        }
    }
    
    public void setCrossings(ConnectionCrossings crossings) {
        this.crossings = crossings;
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return null;
    }
    
    public ConnectionCrossings getConnectionCrossings() {
        return crossings;
    }
}
