/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.events.command;

import java.io.Serializable;

/**
 * 
 * @See {@link Commands} Default commands
 * @See {@link CommandKeyBinding} Default command bindings
 * 
 * @author Toni Kalajainen
 */
public class Command implements Serializable {

    private static final long serialVersionUID = 9117246464320469783L;

    public final String id;

    public Command(String id) {
        if (id == null)
            throw new NullPointerException("null id");
        this.id = id;
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (!(obj instanceof Command))
            return false;
        Command other = (Command) obj;
        return id.equals(other.id);
    }

    @Override
    public String toString() {
        return id;
    }

}
