/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 *
 * @author Toni Kalajainen
 */
package org.simantics.scenegraph.g2d.events.adapter;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import org.simantics.scenegraph.g2d.events.EventDebugPolicy;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.IEventQueue;
import org.simantics.scenegraph.g2d.events.KeyEvent.KeyPressedEvent;
import org.simantics.scenegraph.g2d.events.KeyEvent.KeyReleasedEvent;


public class AWTKeyEventAdapter extends AbstractEventAdapter implements KeyListener {

    private final boolean DEBUG                  = EventDebugPolicy.AWT_KEY_EVENT_ADAPTION;

    private final boolean IGNORE_CONSUMED_EVENTS = false;

    public AWTKeyEventAdapter(Object sender, IEventHandler delegator) {
        super(sender, delegator);
    }

    public AWTKeyEventAdapter(Object sender, IEventQueue queue) {
        super(sender, queue);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (IGNORE_CONSUMED_EVENTS) {
            if (e.isConsumed()) {
                if (DEBUG)
                    System.out.println("AWT key pressed but already consumed: " + e);
                return;
            }
        }
        if (DEBUG)
            System.out.println("AWT key pressed: " + e);
        handleEvent(
                new KeyPressedEvent(sender, e.getWhen(), e.getKeyChar(), e.getKeyCode(), e.getModifiers()));
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (IGNORE_CONSUMED_EVENTS) {
            if (e.isConsumed()) {
                if (DEBUG)
                    System.out.println("AWT key released but already consumed: " + e);
                return;
            }
        }
        if (DEBUG)
            System.out.println("AWT key released: " + e);
        handleEvent(
                new KeyReleasedEvent(sender, e.getWhen(), e.getKeyChar(), e.getKeyCode(), e.getModifiers()));
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (IGNORE_CONSUMED_EVENTS) {
            if (e.isConsumed()) {
                if (DEBUG)
                    System.out.println("AWT key typed but already consumed: " + e);
                return;
            }
        }
        System.out.println("AWT key typed: " + e);
        handleEvent(
                new KeyPressedEvent(sender, e.getWhen(), e.getKeyChar(), e.getKeyCode(), e.getModifiers()));
    }

}
