/*******************************************************************************
 * Copyright (c) 2021 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.color;

import java.awt.Color;

public class DefaultHoverColorFilter implements ColorFilter {

    @Override
    public Color filter(Color c) {
        float[] hsl = rgbToHSL(c);
        Color c2 = hslToRGB(hsl[0], hsl[1], Math.max(0.4f, Math.min(1.0f, 0.3f + 0.7f * (Math.pow(hsl[2], 1.3f)))));
        return c2;
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        return true;
    }
    
    private static Color hslToRGB(double h, double s, double l) {
        double c = (1.0 - Math.abs(2.0 * l - 1.0)) * s;
        double h2 = h / 60.0;
        double x = c * (1.0 - Math.abs((h2 % 2.0) - 1.0));
        double r1 = 0.0;
        double g1 = 0.0;
        double b1 = 0.0;
        if ((0 <= h2) && (h2 < 1)) {
            r1 = c; g1 = x; b1 = 0;
        } else if ((1 <= h2) && (h2 < 2)) {
            r1 = x; g1 = c; b1 = 0;
        } else if ((2 <= h2) && (h2 < 3)) {
            r1 = 0; g1 = c; b1 = x;
        } else if ((3 <= h2) && (h2 < 4)) {
            r1 = 0; g1 = x; b1 = c;
        } else if ((4 <= h2) && (h2 < 5)) {
            r1 = x; g1 = 0; b1 = c;
        } else if ((5 <= h2) && (h2 <= 6)) {
            r1 = c; g1 = 0; b1 = x;
        }
        double m = l - 0.5 * c;
        int R = (int)Math.round((r1 + m) * 255);
        int G = (int)Math.round((g1 + m) * 255);
        int B = (int)Math.round((b1 + m) * 255);
        
        return new Color(R, G, B);
    }
    
    private static float[] rgbToHSL(Color color) {
        float r = color.getRed() / 255.0f;
        float g = color.getGreen() / 255.0f;
        float b = color.getBlue() / 255.0f;

        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));

        float l = (max + min) / 2;

        if (max == min) {
            return new float[] { 0, 0, l };
        }

        float d = max - min;
        float s = d / (l <= 0.5f ? max + min : 2 - max - min); 

        float h = 0;
        if (max == r) {
            h = (60 * (g - b) / d + 360) % 360;
        } else if (max == g) {
            h = 60 * (b - r) / d + 120;
        } else if (max == b) {
            h = 60 * (r - g) / d + 240;
        } 

        return new float[] { h, s, l };
    }
}
