/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

import org.simantics.scl.runtime.tuple.Tuple2;

/**
 * @author Antti Villberg
 * @since 1.29.0
 */
public class AffineTransformFunctions {

	public static Tuple2 transform(AffineTransform transform, Tuple2 point) {
		Point2D result = new Point2D.Double((Double) point.c0, (Double) point.c1);
		transform.transform(result, result);
		return new Tuple2(result.getX(), result.getY());
	}

	public static Tuple2 inverseTransform(AffineTransform transform, Tuple2 point) throws NoninvertibleTransformException {
		Point2D result = new Point2D.Double((Double)point.c0, (Double)point.c1);
		transform.inverseTransform(result, result);
		return new Tuple2(result.getX(), result.getY());
	}

}
