/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.DatabaseManagementResource;
import org.simantics.layer0.Layer0;

public class OntologySpec {
    static String ID_PATTERN_STRING = "[a-zA-Z_0-9]+(?:\\.[a-zA-Z_0-9]+)*";
    static String VERSION_PATTERN_STRING = "(\\d+).(\\d+).(\\d+).([a-zA-Z_0-9\\-]+)";
    static Pattern ID_PATTERN = Pattern.compile(ID_PATTERN_STRING);
    static Pattern VERSION_PATTERN = Pattern.compile(VERSION_PATTERN_STRING);
    static Pattern VERSIONED_ID_PATTERN = Pattern.compile("(" + ID_PATTERN_STRING + ")/" + VERSION_PATTERN_STRING);
    String name;
    String versionedId;
    static Read<List<OntologySpec>> QUERY = new Read<List<OntologySpec>>(){

        public List<OntologySpec> perform(ReadGraph g) throws DatabaseException {
            DatabaseManagementResource DatabaseManagement2 = DatabaseManagementResource.getInstance((ReadGraph)g);
            Layer0 L0 = Layer0.getInstance((ReadGraph)g);
            Collection tgs = g.getObjects(DatabaseManagement2.InstalledGraphBundles, L0.ConsistsOf);
            TreeMap<String, OntologySpec> result = new TreeMap<String, OntologySpec>();
            for (Resource tg : tgs) {
                if (!g.isInstanceOf(tg, DatabaseManagement2.GraphBundle)) continue;
                try {
                    String name = (String)g.getPossibleRelatedValue(tg, L0.HasName);
                    String versionedId = (String)g.getPossibleRelatedValue(tg, DatabaseManagement2.HasVersionedId);
                    OntologySpec bs = new OntologySpec(name, versionedId);
                    result.put(bs.versionedId, bs);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return new ArrayList<OntologySpec>(result.values());
        }
    };

    public OntologySpec(String name, String versionedId) {
        if (!VERSIONED_ID_PATTERN.matcher(versionedId).matches()) {
            throw new IllegalArgumentException("not versioned id");
        }
        this.versionedId = versionedId;
        this.name = name == null ? versionedId : name;
    }

    public String getName() {
        return this.name;
    }

    public String getVersionedId() {
        return this.versionedId;
    }

    public int hashCode() {
        return this.versionedId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OntologySpec)) {
            return false;
        }
        OntologySpec other = (OntologySpec)obj;
        return other.versionedId.equals(this.versionedId);
    }

    public String toString() {
        return String.valueOf(this.name) + "(" + this.versionedId + ")";
    }
}

