/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.utils.Transaction;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.ImportAdvisor;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.diff.Diff;
import org.simantics.graph.diff.TransferableGraphDelta1;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.layer0.DatabaseManagementResource;
import org.simantics.layer0.Layer0;
import org.simantics.project.management.GraphBundle;
import org.simantics.project.management.GraphBundleRef;
import org.simantics.project.ontology.ProjectResource;

public class DatabaseManagement {
    public static final String PROJECTS_URI = "http://Projects";
    Binding tg_binding = Bindings.getBindingUnchecked(TransferableGraph1.class);
    public final Read<Set<String>> ProjectURIQuery = new Read<Set<String>>(){

        public Set<String> perform(ReadGraph g) throws DatabaseException {
            Layer0 b = Layer0.getInstance((ReadGraph)g);
            Resource root = g.getResource(DatabaseManagement.PROJECTS_URI);
            HashSet<String> result = new HashSet<String>();
            for (Resource r : g.getObjects(root, b.ConsistsOf)) {
                result.add(g.getURI(r));
            }
            return result;
        }
    };
    public final Read<Set<Resource>> ProjectsQuery = new Read<Set<Resource>>(){

        public Set<Resource> perform(ReadGraph g) throws DatabaseException {
            Layer0 b = Layer0.getInstance((ReadGraph)g);
            Resource root = g.getResource(DatabaseManagement.PROJECTS_URI);
            return new HashSet<Resource>(g.getObjects(root, b.ConsistsOf));
        }
    };
    public final Read<Set<GraphBundleRef>> GraphBundleRefQuery = new Read<Set<GraphBundleRef>>(){

        public Set<GraphBundleRef> perform(ReadGraph g) throws DatabaseException {
            Object oldGraph = Transaction.setGraph((Object)g);
            try {
                Set<GraphBundleRef> set = DatabaseManagement.this.getGraphBundleReferences();
                return set;
            }
            finally {
                Transaction.setGraph((Object)oldGraph);
            }
        }
    };
    public final Read<Set<GraphBundle>> GraphBundleQuery = new Read<Set<GraphBundle>>(){

        public Set<GraphBundle> perform(ReadGraph g) throws DatabaseException {
            Object oldGraph = Transaction.setGraph((Object)g);
            try {
                Set<GraphBundle> set = DatabaseManagement.this.getGraphBundles();
                return set;
            }
            finally {
                Transaction.setGraph((Object)oldGraph);
            }
        }
    };

    public Resource createProject(String name, Collection<String> features) throws DatabaseException {
        WriteGraph g = Transaction.writeGraph();
        g.setClusterSet4NewResource(g.getRootLibrary());
        Resource root = g.getResource(PROJECTS_URI);
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        ProjectResource PROJ = ProjectResource.getInstance((ReadGraph)g);
        Resource project = g.newResource();
        g.claim(project, L0.InstanceOf, null, PROJ.Project);
        g.claim(project, L0.PartOf, root);
        g.claimLiteral(project, L0.HasName, (Object)name);
        if (Layer0Utils.getPossibleChild((ReadGraph)g, (Resource)root, (String)"Temp") == null) {
            Resource tempLibrary = g.newResource();
            g.claim(tempLibrary, L0.InstanceOf, null, L0.Library);
            g.claimLiteral(tempLibrary, L0.HasName, (Object)"Temp");
            g.claim(root, L0.ConsistsOf, tempLibrary);
        }
        if (Layer0Utils.getPossibleChild((ReadGraph)g, (Resource)root, (String)"TrashBin") == null) {
            Resource trashLibrary = g.newResource();
            g.claim(trashLibrary, L0.InstanceOf, null, L0.Library);
            g.claimLiteral(trashLibrary, L0.HasName, (Object)"TrashBin");
            g.claim(root, L0.ConsistsOf, trashLibrary);
        }
        if (Layer0Utils.getPossibleChild((ReadGraph)g, (Resource)root, (String)"DocumentSessions") == null) {
            Resource documentSessions = g.newResource();
            g.claim(documentSessions, L0.InstanceOf, null, L0.Library);
            g.claimLiteral(documentSessions, L0.HasName, (Object)"DocumentSessions");
            g.claim(root, L0.ConsistsOf, documentSessions);
        }
        for (String feature_uri : features) {
            Resource r = g.getResource(feature_uri);
            g.claim(project, PROJ.HasFeature, r);
        }
        return project;
    }

    public void deleteProject(Resource projectResource) throws DatabaseException {
        WriteGraph g = Transaction.writeGraph();
        Resource root = g.getResource(PROJECTS_URI);
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        g.denyStatement(projectResource, l0.PartOf, root);
    }

    public Collection<Resource> getProjects() throws DatabaseException {
        ReadGraph g = Transaction.readGraph();
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        Resource root = g.getResource(PROJECTS_URI);
        return g.getObjects(root, b.ConsistsOf);
    }

    public void installGraphBundle(GraphBundle tg) throws DatabaseException, TransferableGraphException {
        Resource oldResource = this.getGraphBundleResource(tg.getId(), tg.getMajor());
        if (oldResource == null) {
            ImportAdvisor advisor = new ImportAdvisor();
            long[] resourceArray = TransferableGraphs.importGraph((WriteGraph)Transaction.writeGraph(), (Object)tg.getGraph(), (IImportAdvisor)advisor);
            tg.setResourceArray(resourceArray);
            this.setGraphBundleEntry(tg);
        } else {
            GraphBundle oldTG = this.getGraphBundle(oldResource);
            TransferableGraphDelta1 delta = new Diff(oldTG.getGraph(), tg.getGraph()).diff();
            long[] oldResourceArray = oldTG.getResourceArray();
            long[] newResourceArray = TransferableGraphs.applyDelta((WriteGraph)Transaction.writeGraph(), (long[])oldResourceArray, (TransferableGraphDelta1)delta);
            tg.setResourceArray(newResourceArray);
            this.setGraphBundleEntry(tg);
        }
    }

    public Set<GraphBundle> getGraphBundles() throws DatabaseException {
        ReadGraph g = Transaction.readGraph();
        HashSet<GraphBundle> result = new HashSet<GraphBundle>();
        DatabaseManagementResource DatabaseManagement2 = DatabaseManagementResource.getInstance((ReadGraph)g);
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        for (Resource tg : g.getObjects(DatabaseManagement2.InstalledGraphBundles, L0.ConsistsOf)) {
            if (!g.isInstanceOf(tg, DatabaseManagement2.GraphBundle)) continue;
            String name = (String)g.getPossibleRelatedValue(tg, L0.HasName);
            String vid = (String)g.getPossibleRelatedValue(tg, DatabaseManagement2.HasVersionedId);
            Integer hash = (Integer)g.getPossibleRelatedValue(tg, DatabaseManagement2.HasHashCode);
            GraphBundle entry = new GraphBundle(name, null, vid);
            entry.resource = tg;
            entry.hashcode = hash;
            long[] resourceArray = (long[])g.getPossibleRelatedValue(tg, DatabaseManagement2.HasInstallInfo, (Binding)Bindings.LONG_ARRAY);
            if (resourceArray != null) {
                entry.setResourceArray(resourceArray);
            }
            result.add(entry);
        }
        return result;
    }

    public Set<GraphBundleRef> getGraphBundleReferences() throws DatabaseException {
        ReadGraph g = Transaction.readGraph();
        HashSet<GraphBundleRef> result = new HashSet<GraphBundleRef>();
        DatabaseManagementResource DatabaseManagement2 = DatabaseManagementResource.getInstance((ReadGraph)g);
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        for (Resource tg : g.getObjects(DatabaseManagement2.InstalledGraphBundles, L0.ConsistsOf)) {
            if (!g.isInstanceOf(tg, DatabaseManagement2.GraphBundle)) continue;
            String vid = (String)g.getPossibleRelatedValue(tg, DatabaseManagement2.HasVersionedId);
            result.add(GraphBundleRef.of(vid));
        }
        return result;
    }

    public GraphBundle getGraphBundle(Resource r) throws DatabaseException {
        ReadGraph g = Transaction.readGraph();
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        DatabaseManagementResource DatabaseManagement2 = DatabaseManagementResource.getInstance((ReadGraph)g);
        String name = (String)g.getPossibleRelatedValue(r, L0.HasName);
        String vid = (String)g.getPossibleRelatedValue(r, DatabaseManagement2.HasVersionedId);
        TransferableGraph1 data = (TransferableGraph1)g.getRelatedValue(r, DatabaseManagement2.HasFile, this.tg_binding);
        GraphBundle entry = new GraphBundle(name, data, vid);
        long[] resourceArray = (long[])g.getPossibleRelatedValue(r, DatabaseManagement2.HasInstallInfo, (Binding)Bindings.LONG_ARRAY);
        if (resourceArray != null) {
            entry.setResourceArray(resourceArray);
        }
        return entry;
    }

    public Resource getGraphBundleResource(String id, int major) throws DatabaseException {
        ReadGraph g = Transaction.readGraph();
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        DatabaseManagementResource DatabaseManagement2 = DatabaseManagementResource.getInstance((ReadGraph)g);
        for (Resource r : g.getObjects(DatabaseManagement2.InstalledGraphBundles, L0.ConsistsOf)) {
            String vid;
            Matcher m;
            if (!g.isInstanceOf(r, DatabaseManagement2.GraphBundle) || !(m = GraphBundle.VERSIONED_ID_PATTERN.matcher(vid = (String)g.getRelatedValue(r, DatabaseManagement2.HasVersionedId))).matches()) continue;
            String rid = m.group(1);
            int rmajor = Integer.valueOf(m.group(2));
            if (!rid.equals(id) || rmajor != major) continue;
            return r;
        }
        return null;
    }

    Resource createGraphBundle(GraphBundle entry) throws DatabaseException {
        WriteGraph g = Transaction.writeGraph();
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        DatabaseManagementResource DatabaseManagement2 = DatabaseManagementResource.getInstance((ReadGraph)g);
        Resource r = g.newResource();
        g.claim(r, L0.InstanceOf, DatabaseManagement2.GraphBundle);
        g.addLiteral(r, L0.HasName, L0.NameOf, L0.String, (Object)entry.getName(), (Binding)Bindings.STRING);
        g.addLiteral(r, DatabaseManagement2.HasVersionedId, DatabaseManagement2.HasVersionedId_Inverse, L0.String, (Object)(String.valueOf(entry.getId()) + "/" + entry.getMajor() + "." + entry.getMinor() + "." + entry.getService() + "." + entry.getQualifier()), (Binding)Bindings.STRING);
        g.addLiteral(r, DatabaseManagement2.HasFile, DatabaseManagement2.HasFile_Inverse, L0.Graph, (Object)entry.graph, this.tg_binding);
        g.addLiteral(r, DatabaseManagement2.HasHashCode, DatabaseManagement2.HasHashCode_Inverse, L0.Integer, (Object)entry.hashcode, (Binding)Bindings.INTEGER);
        g.addLiteral(r, DatabaseManagement2.HasInstallInfo, DatabaseManagement2.HasInstallInfo_Inverse, L0.LongArray, (Object)entry.getResourceArray(), (Binding)Bindings.LONG_ARRAY);
        g.claim(DatabaseManagement2.InstalledGraphBundles, L0.ConsistsOf, r);
        return r;
    }

    public Resource createGraphBundle(WriteOnlyGraph g, GraphBundle entry) throws DatabaseException {
        Layer0 L0 = (Layer0)g.getService(Layer0.class);
        DatabaseManagementResource DatabaseManagement2 = (DatabaseManagementResource)g.getService(DatabaseManagementResource.class);
        Resource r = g.newResource();
        g.claim(r, L0.InstanceOf, null, DatabaseManagement2.GraphBundle);
        g.addLiteral(r, L0.HasName, L0.NameOf, L0.String, (Object)entry.getName(), (Binding)Bindings.STRING);
        g.addLiteral(r, DatabaseManagement2.HasVersionedId, DatabaseManagement2.HasVersionedId_Inverse, L0.String, (Object)(String.valueOf(entry.getId()) + "/" + entry.getMajor() + "." + entry.getMinor() + "." + entry.getService() + "." + entry.getQualifier()), (Binding)Bindings.STRING);
        g.addLiteral(r, DatabaseManagement2.HasFile, DatabaseManagement2.HasFile_Inverse, L0.Graph, (Object)entry.graph, this.tg_binding);
        g.addLiteral(r, DatabaseManagement2.HasHashCode, DatabaseManagement2.HasHashCode_Inverse, L0.Integer, (Object)entry.hashcode, (Binding)Bindings.INTEGER);
        g.addLiteral(r, DatabaseManagement2.HasInstallInfo, DatabaseManagement2.HasInstallInfo_Inverse, L0.LongArray, (Object)entry.getResourceArray(), (Binding)Bindings.LONG_ARRAY);
        g.claim(DatabaseManagement2.InstalledGraphBundles, L0.ConsistsOf, L0.PartOf, r);
        return r;
    }

    public Resource setGraphBundleEntry(GraphBundle entry) throws DatabaseException {
        Resource r = this.getGraphBundleResource(entry.getId(), entry.getMajor());
        if (r == null) {
            r = this.createGraphBundle(entry);
            return r;
        }
        WriteGraph g = Transaction.writeGraph();
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        DatabaseManagementResource DatabaseManagement2 = DatabaseManagementResource.getInstance((ReadGraph)g);
        g.claimLiteral(r, L0.HasName, (Object)entry.getName(), (Binding)Bindings.STRING);
        g.claimLiteral(r, DatabaseManagement2.HasVersionedId, (Object)(String.valueOf(entry.getId()) + "/" + entry.getMajor() + "." + entry.getMinor() + "." + entry.getService() + "." + entry.getQualifier()), (Binding)Bindings.STRING);
        g.claimLiteral(r, DatabaseManagement2.HasFile, DatabaseManagement2.HasFile_Inverse, L0.Graph, (Object)entry.graph, this.tg_binding);
        g.claimLiteral(r, DatabaseManagement2.HasHashCode, (Object)entry.hashcode, (Binding)Bindings.INTEGER);
        g.claimLiteral(r, DatabaseManagement2.HasInstallInfo, (Object)entry.getResourceArray(), (Binding)Bindings.LONG_ARRAY);
        return r;
    }
}

