package org.simantics.project.management.install;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.provisional.p2.installer.IInstallOperation;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallAdvisor;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallDescription;

/**
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class DefaultInstallAdvisor extends InstallAdvisor{
	
	private IProgressMonitor monitor = null;
	
	public DefaultInstallAdvisor() {
	}
	
	public IProgressMonitor getMonitor() {
		return monitor;
	}
	
	public void setMonitor(IProgressMonitor monitor) {
		this.monitor = monitor;
	}
	
	@Override
	public IStatus performInstall(IInstallOperation operation) {
		return operation.install(getMonitor());
	}
	
	@Override
	public InstallDescription prepareInstallDescription(
			InstallDescription description) {
		if (description.getInstallLocation() == null)
			throw new IllegalArgumentException("Install location is missing!");
		IPath location = description.getInstallLocation();
		description.setAgentLocation(location.append("p2")); //$NON-NLS-1$
		
		return description;
	}
	
	@Override
	public boolean promptForLaunch(InstallDescription description) {
		return false;
	}
	
	@Override
	public void setResult(IStatus status) {
		if (monitor != null) {
			monitor.done();
		}
	}
	
	@Override
	public void start() {
		
	}
	
	@Override
	public void stop() {
		
	}

		

}
