/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.management;

import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;

/**
 * Project Feature is a end-user installable unit.
 * 
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class FeatureInfo implements IVersionedId {

	public String name;
	public String URI;
	
	/** ID to the transferable graph */
	public IVersionedId vid;
	
	public FeatureInfo(String name, String URI, IVersionedId vid) {
		this.name = name;
		this.URI = URI;
		this.vid = vid;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getURI() {
		return URI;
	}

	public void setURI(String uRI) {
		URI = uRI;
	}

	public IVersionedId getVid() {
		return vid;
	}

	public void setVid(IVersionedId vid) {
		this.vid = vid;
	}

	@Override
	public int hashCode() {
		return vid.getId().hashCode() * 31 + vid.getVersion().hashCode();
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;

		if (!(obj instanceof IVersionedId))
			return false;

		IVersionedId vname = (IVersionedId) obj;
		return vid.getId().equals(vname.getId()) && vid.getVersion().equals(vname.getVersion());
	}

	@Override
	public String getId() {
		return vid.getId();
	}

	@Override
	public Version getVersion() {
		return vid.getVersion();
	}
	
}

