/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.rules.range;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

import org.simantics.objmap.exceptions.MappingException;


/**
 * Accessor for mapped collections. 
 * Uses three methods:
 * - Getter: returns the collection.
 * - Adder: adds one item into the collection.
 * - Remover: removes one item from the collection. 
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 * @param <T>
 */
public class CollectionAccessor<Range,T>  implements IRangeAccessor<Range,Collection<T>> {
	
	private Method getter;
	private Method adder;
	private Method remover;
	
	public CollectionAccessor(Method getter, Method adder, Method remover) {
		this.getter = getter;
		this.adder = adder;
		this.remover = remover;
	}
	
	@SuppressWarnings("unchecked")
	public java.util.Collection<T> get(Object element) throws MappingException {
		try {
			return (Collection<T>) getter.invoke(element);
		} catch (IllegalArgumentException e) {
			throw new MappingException(e);
		} catch (IllegalAccessException e) {
			throw new MappingException(e);
		} catch (InvocationTargetException e) {
			throw new MappingException(e.getCause());
		}
	};

	@Override
	public boolean set(Range element, Collection<T> value)
			throws MappingException {
		java.util.Collection<T> current = get(element);
		Collection<T> adding = new ArrayList<T>();
		Collection<T> removing = new ArrayList<T>();
		for (T e : current) {
			if (!value.contains(e))
				removing.add(e);
		}
		for (T e : value) {
			if (!current.contains(e))
				adding.add(e);
		}
		
		try {
			for (T e : removing) {
				remover.invoke(element, e);
			}
			
			for (T e : adding) {
				adder.invoke(element, e);
			}
		} catch (IllegalArgumentException e) {
			throw new MappingException(e);
		} catch (IllegalAccessException e) {
			throw new MappingException(e);
		} catch (InvocationTargetException e) {
			throw new MappingException(e.getCause());
		}
		return removing.size() > 0 || adding.size() > 0;
		
	}
}
