/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.rules.domain;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.objmap.exceptions.MappingException;


/**
 * Provides access to some property of domain elements.
 * @author Hannu Niemist
 */
public interface IDomainAccessor<Domain,T> {
	T get(ReadGraph g, Domain element) throws MappingException;
	boolean set(WriteGraph g, Domain element, T value) throws MappingException;
}
