/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/**
 * 
 */
package org.simantics.objmap.graph.impl;

import org.simantics.objmap.graph.schema.ILinkType;


/**
 * An indication that the domain element corresponds to the range element
 * in the mapping. The link type describes how source and target objects
 * are updated. There are additionally flags for dirtiness of the link.
 * @author Hannu Niemist
 */
public class Link<Domain,Range> {
	public ILinkType<Domain,Range> type;
	public Domain domainElement;
	public Range rangeElement;
	
	public boolean domainModified = false;
	public boolean rangeModified = false;
	public boolean removed = false;
	
	public Link(ILinkType<Domain,Range> type, Domain domainElement, Range rangeElement) {
		this.type = type;
		this.domainElement = domainElement;
		this.rangeElement = rangeElement;		
	}		
}