/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.svggen.SVGIDGenerator;
import org.simantics.diagram.elements.TextNode;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.IG2DNodeVisitor;
import org.simantics.scenegraph.g2d.nodes.SVGNode;
import org.simantics.scenegraph.g2d.nodes.SelectionNode;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class JSONGenerator
implements IG2DNodeVisitor {
    private static final boolean RENDER_ROUTEGRAPH_CLIENTSIDE = true;
    private SVGIDGenerator idGenerator = new SVGIDGenerator();
    private List<ObjectNode> nodes = new ArrayList<ObjectNode>();
    private ObjectMapper mapper;
    private Map<String, String> newDefs = new HashMap<String, String>();
    private IDiagram diagram;
    private int elements = 0;

    public Map<String, String> flushNewDefs() {
        Map<String, String> result = this.newDefs;
        this.newDefs = new HashMap<String, String>();
        return result;
    }

    public JSONGenerator(ObjectMapper mapper, IDiagram diagram) {
        this.mapper = mapper;
        this.diagram = diagram;
    }

    public List<ObjectNode> getNodes() {
        return this.nodes;
    }

    public void enter(IG2DNode node) {
        Map nodeToElement = (Map)this.diagram.getHint(DiagramHints.NODE_TO_ELEMENT_MAP);
        IElement e = (IElement)nodeToElement.get(node);
        if (e != null) {
            ++this.elements;
        }
        if (this.elements == 1) {
            node.refresh();
            ObjectNode n = this.createJsonNode(node);
            if (n != null) {
                this.nodes.add(n);
            }
        }
    }

    public void leave(IG2DNode node) {
        Map nodeToElement = (Map)this.diagram.getHint(DiagramHints.NODE_TO_ELEMENT_MAP);
        IElement e = (IElement)nodeToElement.get(node);
        if (e != null) {
            --this.elements;
        }
    }

    public String asSVG(IG2DNode node, boolean identityTransform) {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        svgGenerator.getGeneratorContext().setIDGenerator(this.idGenerator);
        svgGenerator.setRenderingHint((RenderingHints.Key)G2DRenderingHints.KEY_TEXT_RENDERING_MODE, (Object)G2DRenderingHints.TextRenderingMode.AS_TEXT);
        svgGenerator.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        svgGenerator.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        svgGenerator.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        svgGenerator.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        svgGenerator.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (identityTransform) {
            AffineTransform save = node.getTransform();
            node.setTransform(AffineTransform.getTranslateInstance(0.0, 0.0));
            node.render((Graphics2D)svgGenerator);
            node.setTransform(save);
        } else {
            node.render((Graphics2D)svgGenerator);
        }
        return JSONGenerator.printSVGDocument(svgGenerator);
    }

    public SVGNode asSVGNode(IG2DNode node) {
        SVGNode svgNode = new SVGNode();
        svgNode.setData(this.asSVG(node, true));
        svgNode.setTransform(node.getTransform());
        return svgNode;
    }

    public ObjectNode createJsonNode(IG2DNode node) {
        Long overrideId = null;
        ParentNode parent = node.getParent();
        if (node instanceof SelectionNode || node instanceof ElementPainter.SelectionShapeNode) {
            return null;
        }
        if (node instanceof RouteGraphNode) {
            ((RouteGraphNode)node).setIgnoreSelection(true);
        }
        if (!JSONGenerator.canRender(node)) {
            overrideId = node.getId();
            node = this.asSVGNode(node);
        }
        ObjectNode n = JSONGenerator.toJSON(this.mapper, node);
        if (overrideId != null) {
            n.put("id", overrideId.longValue());
        }
        if (parent != null) {
            n.put("parent", parent.getId());
        }
        if (node instanceof SVGNode) {
            n.remove("data");
        }
        return n;
    }

    public static ObjectNode toJSON(ObjectMapper mapper, Object object) {
        ObjectNode n = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode types = n.putArray("types");
        Class<?> clazz = object.getClass();
        while (clazz != null && clazz != Object.class) {
            types.add(clazz.getCanonicalName());
            Field[] fieldArray = clazz.getDeclaredFields();
            int n2 = fieldArray.length;
            int n3 = 0;
            while (n3 < n2) {
                block13: {
                    Field field = fieldArray[n3];
                    if (!Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers())) {
                        boolean accessible = field.isAccessible();
                        try {
                            if (!accessible) {
                                field.setAccessible(true);
                            }
                            Object value = field.get(object);
                            n.set(field.getName(), mapper.valueToTree(value));
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                            if (!accessible) {
                                field.setAccessible(false);
                            }
                            break block13;
                        }
                        catch (IllegalAccessException e) {
                            try {
                                e.printStackTrace();
                                break block13;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (!accessible) {
                                    field.setAccessible(false);
                                }
                            }
                        }
                        if (accessible) break block13;
                        field.setAccessible(false);
                    }
                }
                ++n3;
            }
            clazz = clazz.getSuperclass();
        }
        return n;
    }

    public static String printSVGDocument(SVGGraphics2D svgGenerator) {
        StringWriter writer = new StringWriter();
        try {
            svgGenerator.stream(svgGenerator.getRoot(), (Writer)writer, false, false);
        }
        catch (SVGGraphics2DIOException sVGGraphics2DIOException) {}
        return writer.toString();
    }

    private static boolean canRender(IG2DNode node) {
        return node instanceof G2DParentNode || node instanceof SVGNode || node instanceof TextNode || node instanceof RouteGraphNode;
    }
}

