/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions.style;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.simantics.modeling.ui.actions.style.FontChooser;
import org.simantics.modeling.ui.actions.style.Messages;
import org.simantics.modeling.ui.actions.style.MetricsEditor;
import org.simantics.utils.strings.format.MetricsFormat;

public class AWTStyleDialog
extends JDialog {
    private static final long serialVersionUID = 6836378345175793069L;
    private FontChooser fontChooser;
    private JColorChooser colorChooser;
    private MetricsEditor metricsEditor;
    private boolean cancelled = true;
    private boolean useFont = true;
    private boolean useColor = true;
    private boolean useFormat = true;

    public AWTStyleDialog(Frame owner, boolean useFont, boolean useColor, boolean useFormat) {
        super(owner, Messages.AWTStyleDialog_Style, true);
        this.useFont = useFont;
        this.useColor = useColor;
        this.useFormat = useFormat;
        this.createContents();
    }

    public AWTStyleDialog(boolean useFont, boolean useColor, boolean useFormat) {
        this.setTitle(Messages.AWTStyleDialog_Style);
        this.setModal(true);
        this.useFont = useFont;
        this.useColor = useColor;
        this.useFormat = useFormat;
        this.createContents();
    }

    public void setStartFont(Font font) {
        if (!this.useFont) {
            throw new RuntimeException("Dialog is not configured with font support");
        }
        this.fontChooser.setCurrentFont(font);
    }

    public void setStartColor(Color color) {
        if (!this.useColor) {
            throw new RuntimeException("Dialog is not configured with color support");
        }
        this.colorChooser.setColor(color);
    }

    public void setStartFormat(MetricsFormat format) {
        if (!this.useFormat) {
            throw new RuntimeException("Dialog is not configured with format support");
        }
        this.metricsEditor.setMetricsFormat(format);
    }

    private void createContents() {
        JTabbedPane tabbedPane = new JTabbedPane();
        this.getContentPane().add((Component)tabbedPane, "Center");
        if (this.useFont) {
            this.fontChooser = new FontChooser(Messages.AWTStyleDialog_SampleText);
            tabbedPane.addTab(Messages.AWTStyleDialog_Font, this.fontChooser);
        }
        if (this.useColor) {
            this.colorChooser = new JColorChooser(new Color(0, 0, 0));
            tabbedPane.addTab(Messages.AWTStyleDialog_Color, this.colorChooser);
        }
        if (this.useFormat) {
            this.metricsEditor = new MetricsEditor();
            tabbedPane.addTab(Messages.AWTStyleDialog_Metrics, this.metricsEditor);
        }
        JPanel controlPanel = new JPanel();
        this.getContentPane().add((Component)controlPanel, "South");
        controlPanel.setLayout(new FlowLayout(2));
        JButton okButton = new JButton(IDialogConstants.OK_LABEL);
        controlPanel.add(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AWTStyleDialog.this.cancelled = false;
                AWTStyleDialog.this.setVisible(false);
                AWTStyleDialog.this.dispose();
            }
        });
        JButton cancelButton = new JButton(IDialogConstants.CANCEL_LABEL);
        controlPanel.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AWTStyleDialog.this.setVisible(false);
                AWTStyleDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent arg0) {
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
                if (AWTStyleDialog.this.metricsEditor != null) {
                    AWTStyleDialog.this.metricsEditor.dispose();
                }
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
            }

            @Override
            public void windowActivated(WindowEvent arg0) {
            }
        });
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public Font getFont() {
        if (this.fontChooser != null) {
            return this.fontChooser.getFont();
        }
        return null;
    }

    public Color getColor() {
        if (this.colorChooser != null) {
            return this.colorChooser.getColor();
        }
        return null;
    }

    public MetricsFormat getFormat() {
        return this.metricsEditor != null ? this.metricsEditor.getFormat() : null;
    }
}

