package org.simantics.modeling.ui.scl.imports;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.scl.compiler.commands.CommandSessionImportEntry;
import org.simantics.scl.ui.imports.ImportModulesAction;

public class OntologyImportModulesAction extends ImportModulesAction {
    
    public static final OntologyImportModulesAction INSTANCE = new OntologyImportModulesAction();
            
    public OntologyImportModulesAction() {
        super(Messages.OntologyImportModulesAction_AddOntology, 10.0);
    }

    @Override
    public boolean editImports(Shell shell, ArrayList<CommandSessionImportEntry> imports) {
        ModuleSelectionDialog dialog = new ModuleSelectionDialog(shell, OntologiesQuery.INSTANCE);
        dialog.setTitle(Messages.OntologyImportModulesAction_AddOntology);
        if(dialog.open() == Dialog.OK) {
            for(Object r : dialog.getResult()) {
                String uri = (String)r;
                new CommandSessionImportEntry(uri, getDefaultLocalName(uri), true).addTo(imports);
            }
            return true;
        }
        else
            return false;
    }
    
    public String getDefaultLocalName(String ontologyUri) {
        if(ontologyUri.contains("/Layer0-")) //$NON-NLS-1$
            return "L0"; //$NON-NLS-1$
        if(ontologyUri.contains("/Structural-")) //$NON-NLS-1$
            return "STR"; //$NON-NLS-1$
        if(ontologyUri.contains("/Modeling-")) //$NON-NLS-1$
            return "MOD"; //$NON-NLS-1$
        return ""; //$NON-NLS-1$
    }

}
