/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import java.util.Collection;
import java.util.Collections;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.browsing.ui.content.Labeler.Modifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.Activator;

@Deprecated
public class ConnectionUp implements INode {

    Resource sourceRelation;
    Resource target;
    Resource targetRelation;
    Resource connection;

    public ConnectionUp(Resource connection,
            Resource sourceRelation, Resource target, Resource targetRelation) {
        this.connection = connection;
        this.sourceRelation = sourceRelation;
        this.target = target;
        this.targetRelation = targetRelation;
    }

    @Override
    public Collection<?> getChildren(ReadGraph g) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public ImageDescriptor getImage(ReadGraph g) {
        return Activator.ARROW_RIGHT_ICON;
    }

    @Override
    public String getLabel(ReadGraph g) throws DatabaseException {
    	Layer0 b = Layer0.getInstance(g);
        String targetName = g.getPossibleRelatedValue(target, b.HasName);
        if(targetName == null)
            targetName = "";

        String relationName = g.getPossibleRelatedValue(targetRelation, b.HasName);
        if(relationName == null)
            relationName = "";

        return targetName + "." + relationName;
    }

    @Override
    public int getCategory(ReadGraph graph) {
        return 0;
    }

    @Override
    public void handleDrop(Session session, ISelection selection) {
    }

    @Override
    public void handleDelete(WriteGraph graph) throws DatabaseException {
    }

    @Override
    public boolean hasChildren(ReadGraph g) {
        return false;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if(adapter.isAssignableFrom(Resource.class))
            return connection;
        return null;
    }

    @Override
    public Modifier getModifier(Session session, String columnId) {
        return null;
    }

}
