/*******************************************************************************
 * Copyright (c) 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.diagramEditor.dnd;

import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * Represents a suggestion of a fix/change that must be made to the target model
 * before actually performing the element to diagram drop database changes.
 * 
 * The {@link #toString()} method should return a clear description of the
 * suggested fix/change.
 * 
 * @author Tuukka Lehtonen
 * @since 1.37.0
 */
public interface DropSuggestion {

    /**
     * Perform the suggested database fix/change encapsulated by this instance.
     * 
     * @param graph
     * @throws DatabaseException
     */
    void fix(WriteGraph graph) throws DatabaseException;

    /**
     * @return a clear end-user readable description of the suggested fix/change
     */
    @Override
    String toString();

}
