package org.simantics.modeling.ui.componentTypeEditor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;

public class ProceduralComponentInstanceViewerEditorAdapter extends
        AbstractResourceEditorAdapter {
    
    public static final ImageDescriptor ICON = ImageDescriptor.createFromURL(Activator.getDefault().getBundle()
            .getResource("icons/shape_3d_gray.png")); //$NON-NLS-1$
    public static final String EDITOR_ID = "org.simantics.modeling.ui.proceduralComponentInstanceViewer"; //$NON-NLS-1$
    
    public ProceduralComponentInstanceViewerEditorAdapter() {
        super(Messages.ProceduralComponentInstanceViewerEditorAdapter_ProceduralComponentInstanceViewer, ICON, -10);
    }

    private static Resource browseComponent(ReadGraph graph, Resource input) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance(graph);
        
        Resource temp = graph.getPossibleObject(input, MOD.ElementToComponent);
        if(temp != null)
            return temp;
        else
            return input;
    }
    
    @Override
    protected boolean canHandle(ReadGraph graph, Resource input)
            throws DatabaseException {
        input = browseComponent(graph, input);
        StructuralResource2 STR = StructuralResource2.getInstance(graph);
        Resource type = graph.getPossibleType(input, STR.Component);
        if(type == null)
            return false;
        return graph.isInstanceOf(type, STR.ProceduralComponentType);
    }
    
    @Override
    protected void openEditor(final Resource input) throws Exception {
        Simantics.getSession().asyncRequest(new ReadRequest() {
            @Override
            public void run(ReadGraph graph) throws DatabaseException {
                final Resource actualInput = browseComponent(graph, input);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            openEditorWithId(EDITOR_ID, new ResourceEditorInput(EDITOR_ID, actualInput));
                        } catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                    
                });
            }
            
        });
    }
    
}
