/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.chart.property;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.layer0.Layer0;

/**
 * @author Tuukka Lehtonen
 */
public class AvailableTemplateFactory extends ReadFactoryImpl<Resource, Map<String, Object>> {

    @Override
    public Map<String, Object> perform(ReadGraph graph, Resource input) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        ChartResource CHART = ChartResource.getInstance(graph);
        Instances query = graph.adapt(CHART.ChartTemplate, Instances.class);
        Resource model = graph.syncRequest(new PossibleModel(input));
        if (model == null)
            return Collections.emptyMap();
        Map<String, Object> result = new TreeMap<String, Object>();
        for (Resource template : query.find(graph, model)) {
            if (!graph.isInstanceOf(template, CHART.ChartTemplate))
                continue;
            String label = graph.getPossibleRelatedAdapter(template, L0.HasLabel, String.class);
            if (label != null)
                result.put(label, template);
        }
        return result;
    }

}
