/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.adapters;

import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;

/**
 * @author Tuukka Lehtonen
 */
public enum IsInModelTest implements Test {

	INSTANCE;

	public static IsInModelTest get() {
		return INSTANCE;
	}

	@Override
	public boolean isCompatible(Class<?> contentType) {
		return Variable.class.equals(contentType) ||
				Resource.class.equals(contentType);
	}

	@Override
	public boolean test(ReadGraph graph, Object content) throws DatabaseException {
		if (content instanceof Variable) {
			Variable v = (Variable) content;
			//System.out.println("Test variable: " + v.getURI(graph));
			Resource model = Variables.getPossibleModel(graph, v);
			//System.out.println("variable model: " + NameUtils.getURIOrSafeNameInternal(graph, model));
			return model != null;
		} else if (content instanceof Resource) {
			Resource r = (Resource) content;
			//System.out.println("Test resource: " + NameUtils.getURIOrSafeNameInternal(graph, r));
			Resource model = graph.syncRequest(new PossibleModel(r));
			//System.out.println("resource model: " + NameUtils.getURIOrSafeNameInternal(graph, model));
			return model != null;
		}
		return false;
	}

}
