/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.template2d.ui.actions;

import java.util.Arrays;

import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.datatypes.DatatypeResource;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.ontology.ScenegraphResources;

public class NewText implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if(!(target instanceof Resource))
            return null;
        final Resource parent = (Resource)target;

        return new Runnable() {
            @Override
            public void run() {
                Simantics.getSession().asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph g) throws DatabaseException {
                        g.markUndoPoint();
                    	createNewText(g, parent);
                    }
                });
            }
        };
    }
    
    public static Resource createNewText(WriteGraph g, Resource parent) throws DatabaseException {

        Layer0 L0 = Layer0.getInstance(g);
        DiagramResource DIA = DiagramResource.getInstance(g);
        DatatypeResource DATA = DatatypeResource.getInstance(g);
        G2DResource G2D = G2DResource.getInstance(g);
        ScenegraphResources SG = ScenegraphResources.getInstance(g);
        
        Resource monitor = g.newResource();
        g.claim(monitor, L0.InstanceOf, null, DIA.Scenegraph_Text);
        String name = NameUtils.findFreshName(g, "Text", parent, L0.ConsistsOf);
        g.addLiteral(monitor, L0.HasName, L0.NameOf, L0.String, name, Bindings.STRING);
        g.addLiteral(monitor, DIA.Scenegraph_Text_text, DIA.Scenegraph_Monitor_text_Inverse, "text", Bindings.STRING);
        g.addLiteral(monitor, DIA.Scenegraph_AbstractText_width, DIA.Scenegraph_AbstractText_width_Inverse, 0.0f, Bindings.FLOAT);
        g.addLiteral(monitor, DIA.Scenegraph_AbstractText_horizontalAlignment, DIA.Scenegraph_AbstractText_horizontalAlignment_Inverse, L0.Byte, (byte)0, Bindings.BYTE);
        //g.claim(monitor, DIA.Scenegraph_AbstractText_hAlignment, DIA.Scenegraph_AbstractText_hAlignment_Inverse, DIA.Scenegraph_AbstractText_HAlignment_Left);
        g.addLiteral(monitor, DIA.Scenegraph_AbstractText_color, DIA.Scenegraph_AbstractText_color_Inverse, DATA.RGB_Integer, new RGB.Integer(0,0,0), Bindings.getBindingUnchecked(RGB.Integer.class));
        g.addLiteral(monitor, DIA.Scenegraph_AbstractText_font, DIA.Scenegraph_AbstractText_font_Inverse, DATA.Font, new Font("Arial", 12, "Normal"), Bindings.getBindingUnchecked(Font.class));
        g.addLiteral(monitor, DIA.Scenegraph_AbstractText_transform, DIA.Scenegraph_AbstractText_transform_Inverse, G2D.Transform, new Double[] { 1.0, 0.0, 0.0, 1.0, 0.0, 0.0 }, Bindings.getBindingUnchecked(Double[].class));
        g.claim(monitor, L0.PartOf, parent);
        Resource list = g.getPossibleObject(parent, SG.Node_children);
        if (list != null)
        	ListUtils.insertBack(g, list, Arrays.asList(monitor));
        return monitor;
    }
}
