/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.subscription;

import java.util.List;

import org.eclipse.core.runtime.MultiStatus;
import org.simantics.history.util.subscription.SubscriptionItem;
import org.simantics.utils.datastructures.map.Tuple;

/**
 * @author Tuukka Lehtonen
 * 
 * @see ModelHistoryCollector
 * @see Subscription
 */
public class SubscriptionCollectionResult extends Tuple {

    private MultiStatus status;

    public SubscriptionCollectionResult(List<SubscriptionItem> items, MultiStatus status) {
        super(items);
        this.status = status;
    }

    @SuppressWarnings("unchecked")
    public List<SubscriptionItem> getSubscriptions() {
        return (List<SubscriptionItem>) getField(0);
    }

    public MultiStatus getStatus() {
        return status;
    }

}