/*******************************************************************************
 * Copyright (c) 2017, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.actions;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.common.uri.ResourceToPossibleURI;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.request.VariableURI;
import org.simantics.db.layer0.variable.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Jani Simomaa
 * @since 1.30.0
 */
public class CopyURI implements ActionFactory {

    private static final Logger LOGGER = LoggerFactory.getLogger(CopyURI.class);

    @Override
    public Runnable create(Object target) {
        return () -> {
            try {
                String uri = getPossibleURI(target);
                if (uri != null) {
                    Clipboard cb = new Clipboard(Display.getCurrent());
                    cb.setContents(new Object[] { uri }, new Transfer[] { TextTransfer.getInstance() });
                }
            } catch (Exception e) {
                LOGGER.error("Could not get URI for input {} to copy to clipboard", target, e);
            }
        };
    }

    private String getPossibleURI(Object input) throws DatabaseException {
        if (input instanceof Resource) {
            return Simantics.getSession().syncRequest(new ResourceToPossibleURI((Resource) input));
        } else if (input instanceof Variable) {
            return Simantics.getSession().syncRequest(new VariableURI((Variable) input));
        }
        return null;
    }

}
