package org.simantics.modeling;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.LifeCycleContext;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.operation.Layer0X;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.AbstractProjectFeature;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifeCycleProcesses extends AbstractProjectFeature {

	private static final Logger LOGGER = LoggerFactory.getLogger(LifeCycleProcesses.class);

	Set<LifeCycleContext> contexts = Collections.emptySet();

	@Override
	public void configure() throws ProjectException {
		try {
			this.contexts = Simantics.getSession().syncRequest(new Read<Set<LifeCycleContext>>() {

				@Override
				public Set<LifeCycleContext> perform(ReadGraph graph) throws DatabaseException {
					Set<LifeCycleContext> contexts = new HashSet<>();

					Layer0X L0X = Layer0X.getInstance(graph);
					for(Resource indexRoot : Layer0Utils.listIndexRoots(graph)) {
						for(Resource lcp : QueryIndexUtils.searchByTypeShallow(graph, indexRoot, L0X.LifeCycleProcess)) {

							try {
								
								LOGGER.info("Loading life cycle process " + graph.getURI(lcp));
								Function1<LifeCycleContext,Tuple0> load = null; 
								Function1<LifeCycleContext,Tuple0> unload = null;
								Variable process = Variables.getVariable(graph, lcp);
								Variable loadProperty = process.getPossibleProperty(graph, L0X.LifeCycleProcess_load);
								if (loadProperty != null) {
									try {
										load = loadProperty.getValue(graph);
									} catch (DatabaseException e) {
										LOGGER.error("Error loading load property for life cycle process " + graph.getURI(lcp), e);	
									}
								} else {
									LOGGER.info("No load property for life cycle process " + graph.getURI(lcp));
								}
								Variable unloadProperty = process.getPossibleProperty(graph, L0X.LifeCycleProcess_unload);
								if (unloadProperty != null) {
									try {
										unload = unloadProperty.getValue(graph);
									} catch (DatabaseException e) {
										LOGGER.error("Error loading unload property for life cycle process " + graph.getURI(lcp), e);	
									}
								} else {
									LOGGER.info("No unload property for life cycle process " + graph.getURI(lcp));
								}

								LifeCycleContext lcc = new LifeCycleContext(lcp, load, unload);
								contexts.add(lcc);
								
							} catch (DatabaseException e) {
								LOGGER.info("Error loading life cycle process " + graph.getURI(lcp));
							}

						}
					}

					return contexts;
				}
			});

			contexts.forEach(LifeCycleContext::load);

		} catch (DatabaseException e) {
			throw new ProjectException(e);
		}
	}

	@Override
	public void deconfigure() throws ProjectException {
		contexts.forEach(LifeCycleContext::unload);
	}

}
