package org.simantics.modeling;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.stubs.StructuralResource2;

public class GetConnectionTypes {

    public static Collection<Resource> getConnectionTypes(ReadGraph graph, Resource indexRoot) throws DatabaseException {
    	StructuralResource2 STR = StructuralResource2.getInstance(graph);
    	ArrayList<Resource> result = new ArrayList<Resource>();
    	for(Resource type : ModelingUtils.searchByType(graph, indexRoot, STR.ConnectionType)) {
    		boolean user = graph.getRelatedValue2(type, STR.ConnectionType_isUserSelectable, Bindings.BOOLEAN);
    		if(user) result.add(type);
    	}
    	return result;
    }
    
}
