/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.rule.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.mapping.constraint.instructions.IInstruction;

public class UnlessRuleInstruction implements IRuleInstruction {
	IInstruction condition;
	IRuleInstruction rule;
	
	public UnlessRuleInstruction(IInstruction condition, IRuleInstruction rule) {
		this.condition = condition;
		this.rule = rule;
	}
	
	@Override
	public IModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
		if(DEBUG)
			System.out.println("UnlessRuleInstruction.execute: condition");
		Object cont = condition.query(g, bindings);
		if(cont == IInstruction.FAILURE) {
			if(DEBUG)
				System.out.println("UnlessRuleInstruction.execute: execute");
			return rule.execute(g, bindings);
		}
		return null;
	}

	@Override
	public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
		if(DEBUG)
			System.out.println("UnlessRuleInstruction.doExecute: condition");
		Object cont = condition.query(g, bindings);
		if(cont == IInstruction.FAILURE) {
			if(DEBUG)
				System.out.println("UnlessRuleInstruction.doExecute: execute");
			rule.doExecute(g, bindings);
		}
	}
	
	@Override
	public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
		condition.collectVariables(reads, writes);
		rule.collectVariables(reads, writes);
	}

	@Override
	public void mapVariables(TIntIntHashMap map) {
		condition.mapVariables(map);
		rule.mapVariables(map);
	}
	
	@Override
	public void toString(StringBuilder b, int indent) {		
		b.append("unless ");
		condition.toString(b, indent+1);
		b.append('\n');
		
		for(int i=0;i<indent;++i)
			b.append(INDENTATION);
		b.append("then ");
		rule.toString(b, indent+1);	
	}
}
