/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.mapping.constraint.instructions;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public class AndInstruction extends CombinedInstruction {
	
	public AndInstruction(IInstruction... instructions) {
		super(instructions);
	}

	static class Continuation {
		Object continuation;
		int instructionId;	
		Continuation next;		
		
		public Continuation(Object continuation, int instructionId,
				Continuation next) {
			this.continuation = continuation;
			this.instructionId = instructionId;
			this.next = next;
		}

	}
	
	@Override
	public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
		Continuation ret = null;
		int instructionId = 0;
		while(instructionId < instructions.length) {
			if(DEBUG)
				System.out.println("AndInstruction.query " + instructionId + "/" + instructions.length);
			Object continuation = instructions[instructionId].query(g, bindings);
			if(continuation == IInstruction.FAILURE) {
				while(true) {
					if(ret == null)
						return IInstruction.FAILURE;
					instructionId = ret.instructionId;
					continuation = instructions[instructionId].next(g, bindings, ret.continuation);
					if(continuation == IInstruction.FAILURE) {
						ret = ret.next;						
						continue;
					}
					if(continuation == null) 
						ret = ret.next;
					else
						ret.continuation = continuation;
					break;
				}									
			}
			else if(continuation != null)
				ret = new Continuation(continuation, instructionId, ret);
			++instructionId;
		}
		return ret;
	}
	
	@Override
	public Object next(ReadGraph g, Object[] bindings, Object ret_) throws DatabaseException {
		Continuation ret = (Continuation)ret_;
		int instructionId;
		while(true) {
			if(ret == null)
				return IInstruction.FAILURE;
			instructionId = ret.instructionId;
			Object continuation = 
				instructions[instructionId].next(g, bindings, ret.continuation);
			if(continuation == IInstruction.FAILURE) {
				ret = ret.next;						
				continue;
			}
			if(continuation == null) 
				ret = ret.next;
			else
				ret.continuation = continuation;
			break;
		}
		++instructionId;
		while(instructionId < instructions.length) {
			Object continuation = instructions[instructionId].query(g, bindings);
			if(continuation == IInstruction.FAILURE) {
				while(true) {
					if(ret == null)
						return IInstruction.FAILURE;
					instructionId = ret.instructionId;
					continuation = instructions[instructionId].next(g, bindings, ret.continuation);
					if(continuation == IInstruction.FAILURE) {
						ret = ret.next;						
						continue;
					}
					if(continuation == null) 
						ret = ret.next;
					else
						ret.continuation = continuation;
					break;
				}									
			}
			else if(continuation != null)
				ret = new Continuation(continuation, instructionId, ret);
			++instructionId;
		}
		return ret;
	}

	@Override
	public void toString(StringBuilder b, int indent) {		
		b.append("(    ");
		boolean first = true;
		for(IInstruction inst : instructions) {
			if(first)
				first = false;
			else {
				b.append(",\n");
				for(int i=0;i<indent+1;++i)
					b.append(INDENTATION);
			}
			inst.toString(b, indent + 1);			
		}
		b.append('\n');
		for(int i=0;i<indent;++i)
			b.append(INDENTATION);
		b.append(")");		
	}
	
}