/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.properties;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.JFreeChartResource;

/**
 * Class for providing RVI content to a text field with all '/' characters changed to '.'
 * @author Teemu Lempinen
 *
 */
public class RVIFactory extends ReadFactoryImpl<Resource, String> {

    @Override
    public String perform(ReadGraph graph, Resource input) throws DatabaseException {
        String value = graph.getPossibleRelatedValue(input, JFreeChartResource.getInstance(graph).variableRVI);
        return value != null ? value = value.substring(1).replace('/', '.') : "";
    }

}
