package org.simantics.jfreechart.chart.properties;

import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListenerImpl;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.layer0.Layer0;

public class DoublePropertyModifier2 extends TextModifyListenerImpl<Resource> {

	final private String typeUri;
    final private String propertyURI;

    public DoublePropertyModifier2(ISessionContext context, String propertyURI) {
        this.propertyURI = propertyURI;
        this.typeUri = null;
    }
    
    public DoublePropertyModifier2(ISessionContext context, String typeURI, String propertyURI) {
        this.propertyURI = propertyURI;
        this.typeUri = typeURI;
    }

    @Override
    public void applyText(WriteGraph graph, Resource input, String text) throws DatabaseException {
        if (typeUri == null)
        	applyValue(graph, input, text);
        else {
        	Resource type =  graph.getResource(typeUri);
            for(Resource object : graph.syncRequest(new ObjectsWithType(input, Layer0.getInstance(graph).ConsistsOf, type))) {
                applyValue(graph, object,text);
            }
        }
    	
    }
    
    private void applyValue(WriteGraph graph, Resource input, String text) throws DatabaseException {
    	if (text == null || text.trim().isEmpty()) {
            if (graph.hasStatement(input, graph.getResource(propertyURI)))
                graph.denyValue(input, graph.getResource(propertyURI));
        } else {
            graph.claimLiteral(input, graph.getResource(propertyURI), Double.parseDouble(text), Bindings.DOUBLE);
        }
    }

}
