package org.simantics.jfreechart.chart.properties;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.JFreeChartResource;

public class ChartVariableFactory extends ReadFactoryImpl<Resource, ChartVariable>{
	
	private Map<String,ChartVariable> map;
	
	public ChartVariableFactory(Collection<ChartVariable> data) {
		map = new HashMap<String, ChartVariable>();
		for (ChartVariable v : data) {
			map.put(v.getRvi(), v);
		}
	}
	
	@Override
	public ChartVariable perform(ReadGraph graph, Resource input)
			throws DatabaseException {
		 String rvi = graph.getPossibleRelatedValue(input, JFreeChartResource.getInstance(graph).variableRVI);
		 if (rvi == null)
			 return null;
		 return map.get(rvi);
		
	}

}
