/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.ge;

import org.eclipse.jface.resource.FontDescriptor;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.ui.AdaptionUtils;

public class SeriesLabelDecorationRule implements LabelDecorationRule {

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        Resource resource = AdaptionUtils.adaptToSingle(content, Resource.class);
        JFreeChartResource jfree = JFreeChartResource.getInstance(graph);

        if (resource != null && graph.isInstanceOf(resource, jfree.Series)) {
            final String[] filter = graph.getPossibleRelatedValue(resource, jfree.variableFilter, Bindings.STRING_ARRAY);
            if(filter != null) {
                return new LabelDecorator.Stub() {
                    @Override
                    public String decorateLabel(String label, String column, int itemIndex) {
                        label += " [";
                        for(int i = 0; i < filter.length; i++) {
                            label += filter[i];
                            if(i < filter.length - 1)
                                label += ", ";
                        }
                        label += "]";
                        return label;
                    }

                    @SuppressWarnings("unchecked")
                    @Override
                    public <F> F decorateFont(F font, String column, int itemIndex) {
                        return (F) ((FontDescriptor) font);
                    }
                };
            }
        }
        return null;
    }

}
