/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.ge;

import java.util.List;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.jfreechart.chart.properties.xyline.AxisAndVariablesExplorerComposite;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.ui.AdaptionUtils;

/**
 * Action for dropping axis on top of other axis or series in {@link AxisAndVariablesExplorerComposite}
 * @author Teemu Lempinen
 *
 */
public class AxisDropAction  implements DropActionFactory {

    @Override
    public Runnable create(ReadGraph g, Object target, Object source, int operation) throws DatabaseException {
        // Make sure that both target and source are resources
        Resource t = AdaptionUtils.adaptToSingle(target, Resource.class);
        Resource s = AdaptionUtils.adaptToSingle(source, Resource.class);
        
        if(t == null || s == null)
            return null;
        
        // Make sure that source and target are of correct type
        JFreeChartResource jfree = JFreeChartResource.getInstance(g);
        if(!g.isInstanceOf(s, jfree.Axis))
            return null;
        if(!g.isInstanceOf(t, jfree.Series) && !g.isInstanceOf(t, jfree.Axis))
            return null;
        
        return getRunnable(t, s);
    }

    /**
     * Get the runnable for doing the drop action 
     * 
     * @param t target resource
     * @param s source resource
     * @return Runnable
     */
    private Runnable getRunnable(final Resource t, final Resource s) {
        Runnable runnable = new Runnable() {

            @Override
            public void run() {
                Simantics.getSession().asyncRequest(new WriteRequest() {

                    @Override
                    public void perform(WriteGraph graph) throws DatabaseException {
                        if(t == null || s == null) return;
                        JFreeChartResource jfree = JFreeChartResource.getInstance(graph);
                        Layer0 l0 = Layer0.getInstance(graph);
                        Resource target = t;
                        Resource source = s;
                        
                        // Dragged axis always exists in the same list with target axis, so it is safe to get the target index
                        Resource plot = graph.getPossibleObject(source, l0.PartOf);
                        Resource axisListResource = graph.getPossibleObject(plot, jfree.Plot_rangeAxisList);
                        List<Resource> axisList = ListUtils.toList(graph, axisListResource);
                        if(graph.isInstanceOf(target, jfree.Series)) {
                            // Dropped a axis over a series -> get the axis of the series
                            Resource dataset = graph.getPossibleObject(target, l0.PartOf);
                            target = graph.getPossibleObject(dataset, jfree.Dataset_mapToRangeAxis);
                        }
                        
                        // move axis to target position
                        int targetIndex = axisList.indexOf(target);
                        axisList.remove(source);
                        axisList.add(targetIndex, source);
                        
                        // Update the range axis list
                        graph.deny(plot, jfree.Plot_rangeAxisList);
                        axisListResource = ListUtils.create(graph, axisList);
                        graph.claim(plot, jfree.Plot_rangeAxisList, axisListResource);
                    }

                });
            }
        };
        return runnable;
    }

}
