/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.element;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.graph.ElementWriter;
import org.simantics.g2d.element.IElement;
import org.simantics.sysdyn.JFreeChartResource;

/**
 * Element writer for chart elements. ChartElementWriter stores
 * the reference to a chart definition into the element resource
 * @author Teemu Lempinen
 *
 */
public class ChartElementWriter implements ElementWriter {

    @Override
    public void addToGraph(WriteGraph graph, IElement element, Resource elementResource) throws DatabaseException {
        Resource chartComponent = element.getHint(ChartElementFactory.KEY_CHART_COMPONENT);
        if (chartComponent == null)
            throw new IllegalArgumentException("KEY_CHART_COMPONENT hint not set");
        
        JFreeChartResource jfree = JFreeChartResource.getInstance(graph);
        graph.claim(elementResource, jfree.ChartElement_component, chartComponent);
    }

    @Override
    public void removeFromGraph(WriteGraph graph, Resource elementResource) throws DatabaseException {
    }

}
