/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart;

import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleEdge;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;

/**
 * Class representing a JFreeChart.TextTitle
 * @author Teemu Lempinen
 *
 */
public class TextTitle implements ITitle {
    
    private org.jfree.chart.title.TextTitle textTitle;
    private RectangleEdge position;
    private String text;
    private Boolean visible;
    
    public TextTitle(ReadGraph graph, Resource titleResource) {
        Layer0 l0 = Layer0.getInstance(graph);
        JFreeChartResource jfree = JFreeChartResource.getInstance(graph);
        try {
            text = graph.getPossibleRelatedValue(titleResource, l0.HasLabel, Bindings.STRING);
            Resource pos = graph.getPossibleObject(titleResource, jfree.Title_position);
            position = getRectangleEdgePosition(graph, pos);
            visible = graph.getPossibleRelatedValue(titleResource, jfree.visible, Bindings.BOOLEAN);

        } catch (DatabaseException e) {
            e.printStackTrace();
        }
    }
    
    /**
     * Get the RectangleEdge representation for Resource position (JFreeChart.Position)
     * @param graph ReadGraph 
     * @param position Resource of type JFreeChart.Position
     * @return RectangleEdge representation for Resource position
     */
    private RectangleEdge getRectangleEdgePosition(ReadGraph graph, Resource position) {
        if(position == null)
            return null;
        
        JFreeChartResource jfree = JFreeChartResource.getInstance(graph);
        if(position.equals(jfree.Top))
            return RectangleEdge.TOP;
        else if(position.equals(jfree.Bottom))
            return RectangleEdge.BOTTOM;
        else if(position.equals(jfree.Left))
            return RectangleEdge.LEFT;
        else if(position.equals(jfree.Right))
            return RectangleEdge.RIGHT;
        else
            return null;
                    
    }

    @Override
    public Title getTitle() {
        textTitle = new org.jfree.chart.title.TextTitle(text);
        if(position != null)
            textTitle.setPosition(position);
        if(visible != null)
            textTitle.setVisible(visible);
        return textTitle;
    }

    @Override
    public void dispose() {
    }

}
