/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart;

import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;

/**
 * Stacked bar renderer
 * @author Teemu Lempinen
 *
 */
public class StackedBarRenderer extends AbstractRenderer {

    public StackedBarRenderer(ReadGraph graph, Resource resource) {
        super(graph, resource);
    }

    private org.jfree.chart.renderer.category.StackedBarRenderer renderer;
    
    @Override
    public org.jfree.chart.renderer.AbstractRenderer getRenderer() {
        if(renderer == null) {
            renderer = new org.jfree.chart.renderer.category.StackedBarRenderer();
            renderer.setDefaultToolTipGenerator(new StandardCategoryToolTipGenerator());
        }
        return renderer;
    }

}
