package org.simantics.jfreechart.chart;

import java.util.ArrayList;
import java.util.HashMap;

public class PlotProperties {
	 
        public ArrayList<IAxis> ranges;
        public ArrayList<IAxis> domains;
        public ArrayList<IDataset> datasets;
        public HashMap<IDataset, IAxis> rangeMappings;
        public HashMap<IDataset, IAxis> domainMappings;
        public HashMap<String, Object> otherProperties;
        
        public PlotProperties() {
            datasets = new ArrayList<IDataset>();
            rangeMappings = new HashMap<IDataset, IAxis>();
            domainMappings = new HashMap<IDataset, IAxis>();
            ranges = new ArrayList<IAxis>();
            domains = new ArrayList<IAxis>();
            otherProperties = new HashMap<String, Object>();
        }

        @Override
        public boolean equals(Object other) {
            if(!this.getClass().equals(other.getClass()))
                return false;
            PlotProperties p = (PlotProperties)other;
            if(!ranges.equals(p.ranges))
                return false;
            if(!domains.equals(p.domains))
                return false;
            if(!datasets.equals(p.datasets))
                return false;
            if(!rangeMappings.equals(p.rangeMappings))
                return false;
            if(!domainMappings.equals(p.domainMappings))
                return false;
            if(!otherProperties.equals(p.otherProperties))
                return false;
            return true;
        }
	   
}
