package org.simantics.jfreechart.chart;

import java.util.List;

import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

/**
 * Filters PieDataset by creating "Other" item for filtered data.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
@SuppressWarnings("rawtypes")
public class FilteringPieDataset extends AbstractDataset implements PieDataset, FilteredDataset{
	
	private static final long serialVersionUID = -4955124650051030544L;
	
	PieDataset original;
	DefaultPieDataset filtered;
	PieDataset used;
	

	boolean filtering = true;
	double filterFraction = 0.05;
	
	private Comparable other = "other";
	
	public FilteringPieDataset(PieDataset dataset, Comparable other) {
		this.original = dataset;
		this.filtered = new DefaultPieDataset();
		this.other = other;
		this.used = filtered;
		updateFiltered();
	}
	
	@Override
	public boolean isFiltering() {
		return filtering;
	}
	
	@Override
	public void setFiltering(boolean filtering) {
		this.filtering = filtering;
		if (filtering)
			used = filtered;
		else
			used = original;
		fireDatasetChanged();
	}
	

	public void setFilterFraction(double filterFraction) {
		this.filterFraction = filterFraction;
	}
	
	public double getFilterFraction() {
		return filterFraction;
	}
	
	public void updateFiltered() {
		filtered.clear();
		Double total = 0.0;
		Double other = 0.0;
		for (Object key : original.getKeys()) {
			total += original.getValue((Comparable) key).doubleValue();
		}
		total *= filterFraction;
		for (Object key : original.getKeys()) {
			Number value = original.getValue((Comparable) key).doubleValue();
			
			if (value.doubleValue() > total) {
				filtered.setValue((Comparable) key,value);
			} else {
				other += value.doubleValue(); 
			}
		}
		if (other > 0.0) {
			filtered.setValue(this.other, other);
		}
		fireDatasetChanged();
		
	}
	
	@Override
	public List getKeys() {
		return used.getKeys();
	}
	
	@Override
	public int getItemCount() {
		return used.getItemCount();
	}
	
	@Override
	public Comparable getKey(int index) {
		return used.getKey(index);
	}
	
	@Override
	public int getIndex(Comparable key) {
		return used.getIndex(key);
	}
	
	@Override
	public Number getValue(Comparable key) {
		return used.getValue(key);
	}
	
	@Override
	public Number getValue(int index) {
		return used.getValue(index);
	}
	
	public Comparable getOther() {
		return other;
	}

}
