/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart;

import org.jfree.data.Range;

/**
 * NumberAxis that supports adding only one bound, lower or upper.
 * The standard NumberAxis disables auto adjusting if even one of the bounds is set
 * 
 * @author Teemu Lempinen
 *
 */
public class ExtendedNumberAxis  extends org.jfree.chart.axis.NumberAxis {
    private static final long serialVersionUID = 3066266986472919998L;

    private Double lower = null;
    private Double upper = null;
    /**
     * Use own lower and upper bounds to support using only one of them
     */
    protected void autoAdjustRange() {
        super.autoAdjustRange();
        Range range = getRange();
        Double lower = this.lower == null ? range.getLowerBound() : this.lower;
        Double upper = this.upper == null ? range.getUpperBound() : this.upper;
        if(lower > upper)
            upper = lower + 1;
        if(upper - lower < getAutoRangeMinimumSize())
            upper = lower + getAutoRangeMinimumSize();
        
        setRange(new Range(lower, upper), false, false);

    }

    public void setLower(Double lower) {
        this.lower = lower;
    }

    public void setUpper(Double upper) {
        this.upper = upper;
    }

}
